<?php
// CORS configuration
function setupCORS() {
    $allowed_origins = [
        'https://infinitymedical.co',
        'http://infinitymedical.co',
        'http://localhost:3000',
        'http://localhost:5173'
    ];
    
    $origin = $_SERVER['HTTP_ORIGIN'] ?? '';
    
    if (in_array($origin, $allowed_origins)) {
        header("Access-Control-Allow-Origin: $origin");
    } else {
        // Default to main domain if no origin match
        header("Access-Control-Allow-Origin: https://infinitymedical.co");
    }
    
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 3600');
}

// Call the function to set CORS headers
setupCORS();
?>
