<?php
require_once __DIR__ . '/../config/env.php';
require_once __DIR__ . '/../utils/JWTHandler.php';

class AdminController {
    private $jwtHandler;
    
    public function __construct() {
        $this->jwtHandler = new JWTHandler();
    }
    
    public function login() {
        try {
            // Get JSON input
            $input = json_decode(file_get_contents('php://input'), true);
            
            $username = $input['username'] ?? '';
            $password = $input['password'] ?? '';
            
            error_log("Login attempt - Username: $username, Password: $password");
            error_log("Expected - Username: " . ADMIN_USERNAME . ", Password: " . ADMIN_PASSWORD);
            
            // Check credentials
            if ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD) {
                // Create JWT token
                $token = $this->jwtHandler->generateToken([
                    'username' => ADMIN_USERNAME
                ], 7200); // 2 hours
                
                http_response_code(200);
                echo json_encode([
                    'success' => true,
                    'message' => 'Login successful',
                    'token' => $token
                ]);
            } else {
                http_response_code(401);
                echo json_encode([
                    'success' => false,
                    'message' => 'Invalid username or password'
                ]);
            }
            
        } catch (Exception $e) {
            error_log('Login error: ' . $e->getMessage());
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Server error',
                'error' => $e->getMessage()
            ]);
        }
    }
    
    public function dashboard() {
        try {
            // Verify token
            $token = $this->jwtHandler->getTokenFromHeader();
            
            if (!$token) {
                http_response_code(401);
                echo json_encode(['message' => 'No token provided']);
                return;
            }
            
            $payload = $this->jwtHandler->verifyToken($token);
            
            if (!$payload) {
                http_response_code(401);
                echo json_encode(['message' => 'Invalid or expired token']);
                return;
            }
            
            // Return dashboard data
            http_response_code(200);
            echo json_encode([
                'message' => 'Welcome Admin!',
                'admin' => $payload
            ]);
            
        } catch (Exception $e) {
            error_log('Dashboard error: ' . $e->getMessage());
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Server error',
                'error' => $e->getMessage()
            ]);
        }
    }
}
?>
