<?php
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../utils/EmailSender.php';

class FormController {
    private $db;
    private $emailSender;
    
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
        $this->emailSender = new EmailSender();
    }
    
    public function handleDetailedForm() {
        try {
            // Get JSON input
            $input = json_decode(file_get_contents('php://input'), true);
            
            // Validate required fields
            $requiredFields = ['firstName', 'lastName', 'part', 'modality', 'manufacturer'];
            foreach ($requiredFields as $field) {
                if (empty($input[$field])) {
                    http_response_code(400);
                    echo json_encode(['message' => "Field '$field' is required"]);
                    return;
                }
            }
            
            // Prepare data for database
            $data = [
                'first_name' => $input['firstName'],
                'last_name' => $input['lastName'],
                'company_name' => $input['companyName'] ?? '',
                'email' => $input['email'] ?? '',
                'phone_number' => $input['phoneNumber'] ?? '',
                'part' => $input['part'],
                'modality' => $input['modality'],
                'manufacturer' => $input['manufacturer'],
                'part_description' => $input['partDescription'] ?? ''
            ];
            
            // Insert into database
            $stmt = $this->db->prepare("
                INSERT INTO services 
                (first_name, last_name, company_name, email, phone_number, part, modality, manufacturer, part_description) 
                VALUES (:first_name, :last_name, :company_name, :email, :phone_number, :part, :modality, :manufacturer, :part_description)
            ");
            
            $stmt->execute($data);
            
            // Send email notifications
            $this->emailSender->sendFormNotification($data, 'detailed');
            
            // Return success response
            http_response_code(201);
            echo json_encode([
                'message' => 'Form submitted successfully',
                'data' => array_merge($data, ['id' => $this->db->lastInsertId()])
            ]);
            
        } catch (Exception $e) {
            error_log('Form submission error: ' . $e->getMessage());
            http_response_code(500);
            echo json_encode(['message' => 'Server error while submitting form']);
        }
    }
    
    public function handleSimpleForm() {
        try {
            // Get JSON input
            $input = json_decode(file_get_contents('php://input'), true);
            
            // Validate required fields
            $requiredFields = ['firstName', 'lastName', 'partDescription'];
            foreach ($requiredFields as $field) {
                if (empty($input[$field])) {
                    http_response_code(400);
                    echo json_encode(['message' => "Field '$field' is required"]);
                    return;
                }
            }
            
            // Prepare data for database
            $data = [
                'first_name' => $input['firstName'],
                'last_name' => $input['lastName'],
                'company_name' => $input['companyName'] ?? '',
                'email' => $input['email'] ?? '',
                'phone_number' => $input['phoneNumber'] ?? '',
                'part_description' => $input['partDescription']
            ];
            
            // Insert into database
            $stmt = $this->db->prepare("
                INSERT INTO ser 
                (first_name, last_name, company_name, email, phone_number, part_description) 
                VALUES (:first_name, :last_name, :company_name, :email, :phone_number, :part_description)
            ");
            
            $stmt->execute($data);
            
            // Send email notifications
            $this->emailSender->sendFormNotification($data, 'simple');
            
            // Return success response
            http_response_code(201);
            echo json_encode([
                'message' => 'Form submitted successfully',
                'data' => array_merge($data, ['id' => $this->db->lastInsertId()])
            ]);
            
        } catch (Exception $e) {
            error_log('Form submission error: ' . $e->getMessage());
            http_response_code(500);
            echo json_encode(['message' => 'Server error while submitting form']);
        }
    }
}
?>
