<?php
require_once __DIR__ . '/../config/env.php';

class EmailSender {
    private $smtpHost;
    private $smtpPort;
    private $smtpUsername;
    private $smtpPassword;
    private $fromEmail;
    private $fromName;
    
    public function __construct() {
        $this->smtpHost = SMTP_HOST;
        $this->smtpPort = SMTP_PORT;
        $this->smtpUsername = SMTP_USERNAME;
        $this->smtpPassword = SMTP_PASSWORD;
        $this->fromEmail = SMTP_FROM_EMAIL;
        $this->fromName = SMTP_FROM_NAME;
    }
    
    public function sendMail($to, $subject, $htmlContent, $textContent = '') {
        try {
            // Create email headers
            $headers = [
                'MIME-Version: 1.0',
                'Content-Type: text/html; charset=UTF-8',
                'From: ' . $this->fromName . ' <' . $this->fromEmail . '>',
                'Reply-To: ' . $this->fromEmail,
                'X-Mailer: PHP/' . phpversion()
            ];
            
            // Send email using PHP's mail function
            $success = mail($to, $subject, $htmlContent, implode("\r\n", $headers));
            
            if ($success) {
                error_log("Email sent successfully to: $to");
                return true;
            } else {
                error_log("Failed to send email to: $to");
                return false;
            }
        } catch (Exception $e) {
            error_log("Email sending error: " . $e->getMessage());
            return false;
        }
    }
    
    public function sendFormNotification($formData, $formType = 'contact') {
        $adminEmail = 'globalinfinity580@gmail.com';
        $customerEmail = $formData['email'] ?? '';
        
        // Send admin notification
        $this->sendAdminNotification($adminEmail, $formData, $formType);
        
        // Send customer confirmation
        if ($customerEmail) {
            $this->sendCustomerConfirmation($customerEmail, $formData, $formType);
        }
    }
    
    private function sendAdminNotification($adminEmail, $formData, $formType) {
        $subject = $this->getAdminSubject($formType);
        $html = $this->generateAdminEmailHtml($formData, $formType);
        
        $this->sendMail($adminEmail, $subject, $html);
    }
    
    private function sendCustomerConfirmation($customerEmail, $formData, $formType) {
        $subject = 'Thank You for Contacting Us!';
        $html = $this->generateCustomerEmailHtml($formData, $formType);
        
        $this->sendMail($customerEmail, $subject, $html);
    }
    
    private function getAdminSubject($formType) {
        switch ($formType) {
            case 'rental':
                return 'New Rental Service Form Submission';
            case 'detailed':
                return 'New Contact Form Submission';
            case 'simple':
            default:
                return 'New Contact Form Submission';
        }
    }
    
    private function generateAdminEmailHtml($formData, $formType) {
        $firstName = $formData['first_name'] ?? '';
        $lastName = $formData['last_name'] ?? '';
        $companyName = $formData['company_name'] ?? '';
        $email = $formData['email'] ?? '';
        $phoneNumber = $formData['phone_number'] ?? '';
        $partDescription = $formData['part_description'] ?? '';
        
        $html = '<div style="font-family: Arial, sans-serif; line-height: 1.6; color: #333;">';
        
        if ($formType === 'rental') {
            $rentalService = $formData['rental_service'] ?? '';
            $html .= '<h2 style="color: #0056b3;">New Rental Service Submission</h2>';
            $html .= "<p><strong>Name:</strong> $firstName $lastName</p>";
            $html .= "<p><strong>Company Name:</strong> $companyName</p>";
            $html .= "<p><strong>Email:</strong> $email</p>";
            $html .= "<p><strong>Phone Number:</strong> $phoneNumber</p>";
            $html .= "<p><strong>Rental Service:</strong> $rentalService</p>";
            $html .= "<p><strong>Description:</strong> $partDescription</p>";
        } elseif ($formType === 'detailed') {
            $part = $formData['part'] ?? '';
            $modality = $formData['modality'] ?? '';
            $manufacturer = $formData['manufacturer'] ?? '';
            $html .= '<h2 style="color: #0056b3;">New Contact Submission</h2>';
            $html .= "<p><strong>Name:</strong> $firstName $lastName</p>";
            $html .= "<p><strong>Company:</strong> $companyName</p>";
            $html .= "<p><strong>Email:</strong> $email</p>";
            $html .= "<p><strong>Phone:</strong> $phoneNumber</p>";
            $html .= "<p><strong>Part:</strong> $part</p>";
            $html .= "<p><strong>Modality:</strong> $modality</p>";
            $html .= "<p><strong>Manufacturer:</strong> $manufacturer</p>";
            $html .= "<p><strong>Description:</strong> $partDescription</p>";
        } else {
            $html .= '<h2 style="color: #0056b3;">New Contact Submission</h2>';
            $html .= "<p><strong>Name:</strong> $firstName $lastName</p>";
            $html .= "<p><strong>Company Name:</strong> $companyName</p>";
            $html .= "<p><strong>Email:</strong> $email</p>";
            $html .= "<p><strong>Phone Number:</strong> $phoneNumber</p>";
            $html .= "<p><strong>Part Description:</strong> $partDescription</p>";
        }
        
        $html .= '<hr/>';
        $html .= '<p style="font-size: 13px; color: #888;">This message was generated automatically from your website form.</p>';
        $html .= '</div>';
        
        return $html;
    }
    
    private function generateCustomerEmailHtml($formData, $formType) {
        $firstName = $formData['first_name'] ?? '';
        $email = $formData['email'] ?? '';
        $phoneNumber = $formData['phone_number'] ?? '';
        $partDescription = $formData['part_description'] ?? '';
        
        $html = "<h3>Dear $firstName,</h3>";
        
        if ($formType === 'rental') {
            $rentalService = $formData['rental_service'] ?? '';
            $html .= '<p>Thank you for contacting us regarding equipment rental. We have received your details and our team will contact you shortly.</p>';
            $html .= '<p><strong>Your Submitted Information:</strong></p>';
            $html .= '<ul>';
            $html .= "<li><strong>Email:</strong> $email</li>";
            $html .= "<li><strong>Phone:</strong> $phoneNumber</li>";
            $html .= "<li><strong>Rental Service:</strong> $rentalService</li>";
            $html .= "<li><strong>Description:</strong> " . ($partDescription ?: 'N/A') . "</li>";
            $html .= '</ul>';
        } elseif ($formType === 'detailed') {
            $part = $formData['part'] ?? '';
            $modality = $formData['modality'] ?? '';
            $manufacturer = $formData['manufacturer'] ?? '';
            $html .= '<p>Thank you for contacting us. We have received your inquiry and will get back to you shortly.</p>';
            $html .= '<p><strong>Your Provided Details:</strong></p>';
            $html .= '<ul>';
            $html .= "<li><strong>Email:</strong> $email</li>";
            $html .= "<li><strong>Phone:</strong> $phoneNumber</li>";
            $html .= "<li><strong>Part:</strong> $part</li>";
            $html .= "<li><strong>Modality:</strong> $modality</li>";
            $html .= "<li><strong>Manufacturer:</strong> $manufacturer</li>";
            $html .= "<li><strong>Description:</strong> " . ($partDescription ?: 'N/A') . "</li>";
            $html .= '</ul>';
        } else {
            $html .= '<p>Thank you for submitting your details. Our team will contact you shortly.</p>';
            $html .= '<p><strong>Your Submitted Information:</strong></p>';
            $html .= '<ul>';
            $html .= "<li><strong>Email:</strong> $email</li>";
            $html .= "<li><strong>Phone:</strong> $phoneNumber</li>";
            $html .= "<li><strong>Part Description:</strong> " . ($partDescription ?: 'N/A') . "</li>";
            $html .= '</ul>';
        }
        
        $html .= '<p>Best Regards,<br/>Promed Solutions Team</p>';
        
        return $html;
    }
}
?>
